<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\UserSession;
use App\Http\Controllers\SessionController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TestSessionMethods extends Command
{
    protected $signature = 'test:session-methods';
    protected $description = 'Prueba los métodos del SessionController';

    public function handle()
    {
        $this->info('Probando métodos del SessionController...');

        // Obtener un usuario
        $user = User::with('plan')->first();

        if (!$user) {
            $this->error('No hay usuarios en la base de datos');
            return;
        }

        $this->info("Usando usuario: {$user->email}");
        $this->info("Plan: " . ($user->plan ? $user->plan->nombre : 'Sin plan'));

        // Simular autenticación
        Auth::login($user);

        try {
            // Probar métodos del usuario
            $this->info('--- Métodos del modelo User ---');
            $this->info("getLimiteSesiones(): " . $user->getLimiteSesiones());
            $this->info("getSesionesActivasCount(): " . $user->getSesionesActivasCount());
            $this->info("haAlcanzadoLimiteSesiones(): " . ($user->haAlcanzadoLimiteSesiones() ? 'Sí' : 'No'));

            // Probar métodos del controlador
            $this->info('--- Métodos del SessionController ---');
            $controller = new SessionController();

            // Crear request simulado
            $request = Request::create('/sessions/status', 'GET');
            $request->setUserResolver(function () use ($user) {
                return $user;
            });

            // Probar getSessionStatus
            $response = $controller->getSessionStatus();
            $this->info("getSessionStatus response status: " . $response->getStatusCode());
            $this->info("getSessionStatus response content: " . $response->getContent());
        } catch (\Exception $e) {
            $this->error("Error: " . $e->getMessage());
            $this->error("Archivo: " . $e->getFile() . ":" . $e->getLine());
            $this->error("Stack trace:");
            $this->error($e->getTraceAsString());
        }
    }
}
