<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePlanRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nombre' => 'required|string|max:255|unique:planes,nombre',
            'descripcion' => 'nullable|string|max:500',
            'max_sesiones' => 'required|integer|min:1|max:999',
            'max_datos_mb' => 'nullable|integer|min:1',
            'max_reportes' => 'nullable|integer|min:1',
            'max_carteras' => 'nullable|integer|min:1',
            'creditos_diarios' => 'required|integer|min:0',
            'creditos_mensuales' => 'required|integer|min:0',
            'precio_mensual' => 'nullable|numeric|min:0',
            'activo' => 'boolean',
            'orden' => 'nullable|integer|min:0',
            'configuraciones_adicionales' => 'nullable|array',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'nombre.required' => 'El nombre del plan es obligatorio.',
            'nombre.unique' => 'Ya existe un plan con este nombre.',
            'max_sesiones.required' => 'El número máximo de sesiones es obligatorio.',
            'max_sesiones.min' => 'El número máximo de sesiones debe ser al menos 1.',
            'creditos_diarios.required' => 'Los créditos diarios son obligatorios.',
            'creditos_mensuales.required' => 'Los créditos mensuales son obligatorios.',
        ];
    }
}
