<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    protected $table = 'planes';

    protected $fillable = [
        'nombre',
        'descripcion',
        'max_sesiones',
        'max_datos_mb',
        'max_reportes',
        'max_carteras',
        'creditos_diarios',
        'creditos_mensuales',
        'configuraciones_adicionales',
        'precio_mensual',
        'activo',
        'orden',
    ];

    protected $casts = [
        'configuraciones_adicionales' => 'array',
        'activo' => 'boolean',
        'precio_mensual' => 'decimal:2',
        'creditos_diarios' => 'integer',
        'creditos_mensuales' => 'integer',
    ];

    /**
     * Usuarios que tienen este plan
     */
    public function users()
    {
        return $this->hasMany(User::class, 'plan_id');
    }

    /**
     * Scope para planes activos
     */
    public function scopeActivos($query)
    {
        return $query->where('activo', true);
    }

    /**
     * Scope para ordenar por prioridad
     */
    public function scopeOrdenados($query)
    {
        return $query->orderBy('orden');
    }

    /**
     * Verifica si el plan tiene una característica específica
     */
    public function tieneCaracteristica($caracteristica)
    {
        return $this->$caracteristica ?? false;
    }

    /**
     * Obtiene el límite de una configuración específica
     */
    public function getLimite($configuracion)
    {
        return $this->$configuracion;
    }
}
