<?php

namespace App\Policies;

use App\Models\Reporte;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class ReportePolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('reportes.ver');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Reporte $reporte): bool
    {
        // Verificar si el usuario tiene acceso directo al reporte
        if ($user->reportes()->where('reporte_id', $reporte->id)->exists()) {
            return true;
        }

        // Verificar si el usuario tiene acceso a través de su rol
        $userReportes = $user->getEffectiveReportes();
        return $userReportes->contains('id', $reporte->id);
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->can('reportes.crear');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Reporte $reporte): bool
    {
        return $user->can('reportes.editar');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Reporte $reporte): bool
    {
        return $user->can('reportes.eliminar');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Reporte $reporte): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Reporte $reporte): bool
    {
        return false;
    }
}
