<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('planes', function (Blueprint $table) {
            $table->id();
            $table->string('nombre')->unique(); // Básico, Pro, Premium, etc.
            $table->string('descripcion')->nullable();
            $table->integer('max_sesiones')->default(1); // Máximo de sesiones concurrentes
            $table->integer('max_datos_mb')->nullable(); // Límite de datos en MB (null = ilimitado)
            $table->integer('max_reportes')->nullable(); // Máximo reportes que puede crear
            $table->integer('max_carteras')->nullable(); // Máximo carteras que puede gestionar

            // Límites de créditos para enriquecimiento operador
            $table->integer('creditos_diarios')->default(0); // Números que puede procesar por día
            $table->integer('creditos_mensuales')->default(0); // Números que puede procesar por mes

            $table->json('configuraciones_adicionales')->nullable(); // Para futuras config
            $table->decimal('precio_mensual', 10, 2)->nullable(); // Precio del plan
            $table->boolean('activo')->default(true);
            $table->integer('orden')->default(0); // Para ordenar planes
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('planes');
    }
};
