<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('enriquecimiento_numeros', function (Blueprint $table) {
            $table->id();

            // Relación con la importación
            $table->foreignId('importacion_id')->constrained('enriquecimiento_importaciones')->onDelete('cascade');

            // Número de teléfono original
            $table->string('numero_telefono', 20); // Número original subido
            $table->string('numero_normalizado', 20)->nullable(); // Número normalizado (formato estándar)

            // Información del operador (será llenada por el bot)
            $table->string('operador_origen')->nullable(); // Operador original
            $table->string('operador_actual')->nullable(); // Operador actual
            $table->timestamp('fecha_actualizacion_operador')->nullable(); // Cuándo se actualizó el operador

            // Estado del procesamiento
            $table->enum('estado', [
                'pendiente',    // Sin procesar
                'procesando',   // Siendo procesado por el bot
                'procesado',    // Procesado exitosamente
                'rechazado',    // Rechazado o con error
                'cancelado'     // Cancelado por el usuario (no se puede reanudar)
            ])->default('pendiente');

            // Metadatos del procesamiento
            $table->json('datos_adicionales')->nullable(); // Datos extra del bot
            $table->text('error_detalle')->nullable(); // Detalle del error si lo hay
            $table->timestamp('fecha_procesamiento')->nullable(); // Cuándo fue procesado

            // Fecha de registro del número
            $table->timestamp('fecha_registro')->useCurrent(); // Cuándo se registró el número

            $table->timestamps();

            // Índices para optimizar consultas
            $table->index(['importacion_id', 'estado']);
            $table->index('numero_telefono');
            $table->index('numero_normalizado');
            $table->index('operador_actual');
            $table->index('estado');
            $table->index('fecha_registro');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('enriquecimiento_numeros');
    }
};
