<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Module;
use App\Models\Permission;
use App\Models\Role;

class PermissionSeeder extends Seeder
{
    public function run(): void
    {

        $modulosConPermisos = [
            'Roles' => ['ver', 'crear', 'editar', 'eliminar'],
            'Usuarios' => ['ver', 'crear',  'editar', 'eliminar'],
            'Carteras' => ['ver', 'crear',  'editar', 'eliminar'],
            'Reportes' => ['ver', 'crear', 'editar', 'eliminar'],
            'Profiles' => [
                'ver-directorio',    // puede acceder al directorio de perfiles públicos
                'ver-perfil-publico', // puede ver perfiles públicos individuales
                'ver-todos',          // puede ver todos los perfiles (incluso privados)
            ],
            'Vodafone' => [
                'ver',           // ver registros
                'crear',
                'editar',
                'eliminar',
                'ver-global',
                'importar',   // importar registros de otros
                'asignar',       // asignar registros
                'recibe-asignacion', // se puede asignar a este usuario
                'ver-historial', // ver historial de asignaciones
                'filtrar',       // puede filtrar registros asignados (solo por trazabilidad)
                'editar-completados',
                'agendar', // puede editar campos limitados en registros completados
            ],
            'Planes'   => ['ver', 'crear', 'editar', 'eliminar'],
            'Enriquecimiento' => ['ver', 'crear', 'eliminar', 'importar', 'exportar', 'pausar'],
        ];

        foreach ($modulosConPermisos as $moduloNombre => $acciones) {
            $modulo = Module::firstOrCreate(['name' => $moduloNombre]);
            $moduloSlug = strtolower(str_replace(' ', '-', $moduloNombre));

            foreach ($acciones as $accion) {
                $permisoNombre = "{$moduloSlug}.{$accion}";
                Permission::firstOrCreate([
                    'name' => $permisoNombre,
                    'guard_name' => 'web',
                    'module_id' => $modulo->id,
                ]);
            }
        }

        // ROL ADMIN
        $rolAdmin = Role::firstOrCreate([
            'name' => 'admin',
            'guard_name' => 'web',
        ]);
        $todosPermisos = Permission::where('name', '!=', 'vodafone.recibe-asignacion')->get();
        $rolAdmin->syncPermissions($todosPermisos);

        $rolAsesor = Role::firstOrCreate([
            'name' => 'asesor',
            'guard_name' => 'web',
        ]);

        // ROL COORDINADOR
        $rolCoordinador = Role::firstOrCreate([
            'name' => 'coordinador-vodafone',
            'guard_name' => 'web',
        ]);
        $permisosCoordinador = [
            'vodafone.ver',
            'vodafone.editar',
            'vodafone.crear',
            'vodafone.importar',
            'vodafone.ver-global',
            'vodafone.asignar',
            'vodafone.ver-historial',
            'vodafone.editar-completados',
            'vodafone.agendar',
            'profiles.ver-directorio',
            'profiles.ver-perfil-publico',
        ];
        foreach ($permisosCoordinador as $permiso) {
            Permission::firstOrCreate([
                'name' => $permiso,
                'guard_name' => 'web',
            ]);
        }
        $rolCoordinador->syncPermissions($permisosCoordinador);

        // ROL FILTRADOR
        $rolFiltrador = Role::firstOrCreate([
            'name' => 'filtrador-vodafone',
            'guard_name' => 'web',
        ]);
        $permisosFiltrador = [
            'vodafone.ver',
            'vodafone.editar',
            'vodafone.recibe-asignacion',
            'vodafone.filtrar',
            'vodafone.editar-completados',
            'vodafone.agendar',
            'profiles.ver-directorio',
            'profiles.ver-perfil-publico',
        ];
        foreach ($permisosFiltrador as $permiso) {
            Permission::firstOrCreate([
                'name' => $permiso,
                'guard_name' => 'web',
            ]);
        }
        $rolFiltrador->syncPermissions($permisosFiltrador);

        // ROL ASESOR VODAFONE
        $rolAsesorVodafone = Role::firstOrCreate([
            'name' => 'asesor-vodafone',
            'guard_name' => 'web',
        ]);
        $permisosAsesorVodafone = [
            'vodafone.ver',
            'vodafone.agendar',
        ];
        foreach ($permisosAsesorVodafone as $permiso) {
            Permission::firstOrCreate([
                'name' => $permiso,
                'guard_name' => 'web',
            ]);
        }
        $rolAsesorVodafone->syncPermissions($permisosAsesorVodafone);

        // ROL DE PRUEBA
        $rolTester = Role::firstOrCreate([
            'name' => 'tester',
            'guard_name' => 'web',
        ]);
        $permisosTester = [
            'carteras.ver',
            'carteras.editar',
        ];
        foreach ($permisosTester as $permiso) {
            Permission::firstOrCreate([
                'name' => $permiso,
                'guard_name' => 'web',
            ]);
        }
        $rolTester->syncPermissions($permisosTester);
    }
}
