<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Plan;

class PlanesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $planes = [
            [
                'nombre' => 'Básico',
                'descripcion' => 'Plan básico para usuarios individuales',
                'max_sesiones' => 1,
                'max_datos_mb' => 100,
                'max_reportes' => 5,
                'max_carteras' => 2,
                'creditos_diarios' => 10,
                'creditos_mensuales' => 1000,
                'precio_mensual' => 0.00,
                'activo' => true,
                'orden' => 1,
                'configuraciones_adicionales' => [
                    'tiempo_sesion' => 30, // minutos
                    'backup_automatico' => false,
                    'soporte_prioritario' => false
                ]
            ],
            [
                'nombre' => 'Profesional',
                'descripcion' => 'Plan profesional para equipos pequeños',
                'max_sesiones' => 3,
                'max_datos_mb' => 500,
                'max_reportes' => 25,
                'max_carteras' => 10,
                'creditos_diarios' => 500,
                'creditos_mensuales' => 10000,
                'precio_mensual' => 29.99,
                'activo' => true,
                'orden' => 2,
                'configuraciones_adicionales' => [
                    'tiempo_sesion' => 60, // minutos
                    'backup_automatico' => true,
                    'soporte_prioritario' => false,
                    'integraciones_externas' => true
                ]
            ],
            [
                'nombre' => 'Empresarial',
                'descripcion' => 'Plan empresarial para organizaciones grandes',
                'max_sesiones' => 10,
                'max_datos_mb' => null, // ilimitado
                'max_reportes' => null, // ilimitado
                'max_carteras' => null, // ilimitado
                'creditos_diarios' => 2000,
                'creditos_mensuales' => 50000,
                'precio_mensual' => 99.99,
                'activo' => true,
                'orden' => 3,
                'configuraciones_adicionales' => [
                    'tiempo_sesion' => 120, // minutos
                    'backup_automatico' => true,
                    'soporte_prioritario' => true,
                    'integraciones_externas' => true,
                    'sso_enabled' => true,
                    'auditoria_avanzada' => true
                ]
            ],
            [
                'nombre' => 'Premium',
                'descripcion' => 'Plan premium con características ilimitadas',
                'max_sesiones' => 999, // prácticamente ilimitado
                'max_datos_mb' => null,
                'max_reportes' => null,
                'max_carteras' => null,
                'creditos_diarios' => 10000,
                'creditos_mensuales' => 200000,
                'precio_mensual' => 199.99,
                'activo' => true,
                'orden' => 4,
                'configuraciones_adicionales' => [
                    'tiempo_sesion' => 240, // minutos
                    'backup_automatico' => true,
                    'soporte_prioritario' => true,
                    'integraciones_externas' => true,
                    'sso_enabled' => true,
                    'auditoria_avanzada' => true,
                    'white_label' => true,
                    'api_rate_limit' => 10000
                ]
            ]
        ];

        foreach ($planes as $plan) {
            Plan::create($plan);
        }

        $this->command->info('Planes creados exitosamente:');
        $this->command->info('- Básico (1 sesión)');
        $this->command->info('- Profesional (3 sesiones)');
        $this->command->info('- Empresarial (10 sesiones)');
        $this->command->info('- Premium (999 sesiones)');
    }
}
