<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Plan;

class UpdateUsersWithBasicPlan extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $basicPlan = Plan::where('nombre', 'Básico')->first();

        if (!$basicPlan) {
            $this->command->error('No se encontró el plan Básico. Ejecuta primero el PlanesSeeder.');
            return;
        }

        $usuariosSinPlan = User::whereNull('plan_id')->get();

        foreach ($usuariosSinPlan as $usuario) {
            $usuario->plan_id = $basicPlan->id;
            $usuario->save();
        }

        $totalActualizados = $usuariosSinPlan->count();

        $this->command->info("✅ {$totalActualizados} usuario(s) actualizado(s) con el plan Básico.");
        $this->command->info("📊 Resumen por planes:");

        $resumen = Plan::withCount('users')->get();
        foreach ($resumen as $plan) {
            $this->command->info("   - {$plan->nombre}: {$plan->users_count} usuario(s)");
        }
    }
}
