import axios from "axios";
window.axios = axios;

window.axios.defaults.headers.common["X-Requested-With"] = "XMLHttpRequest";

// Interceptor para detectar sesiones invalidadas
window.axios.interceptors.response.use(
    (response) => {
        return response;
    },
    (error) => {
        // Si recibimos 401 o 419 (token expirado), la sesión es inválida
        if (
            error.response &&
            (error.response.status === 401 || error.response.status === 419)
        ) {
            // Solo redirigir si no estamos ya en login
            if (!window.location.pathname.includes("/login")) {
                window.location.href = "/login";
            }
        }
        return Promise.reject(error);
    }
);
